// 用户交互——鼠标2
#include <graphics.h>

#include <stdio.h>

int main()
{
    initgraph(640, 480);

    setfont(18, 0, "宋体");

    mouse_msg msg = {0};
    for ( ; is_run(); delay_fps(60))
    {
        // 获取鼠标消息，这个函数会等待，等待到有消息为止
        // 类似地，有和kbhit功能相近的函数MouseHit，用于检测有没有鼠标消息
        while (mousemsg())
        {
            msg = getmouse();
        }

        // 格式化输出为字符串，用于后面输出
        // msg 和 flag 常数请参考文档或者 mouse_msg_e, mouse_flag_e 的声明

        cleardevice();
        xyprintf(0, 0, "x = %10d  y = %10d",
            msg.x, msg.y, msg.wheel);
        xyprintf(0, 20, "move  = %d down  = %d up    = %d",
            (int)msg.is_move(),
            (int)msg.is_down(),
            (int)msg.is_up());
        xyprintf(0, 40, "left  = %d mid   = %d right = %d",
            (int)msg.is_left(),
            (int)msg.is_mid(),
            (int)msg.is_right());
        xyprintf(0, 60, "wheel = %d  wheel rotate = %d",
            (int)msg.is_wheel(),
            msg.wheel);
    }

    closegraph();
    return 0;
}
